/*
 * Decompiled with CFR 0.152.
 */
package ru.dvo.iacp.is.iacpaas.ui;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import mjson.Json;
import ru.dvo.iacp.is.iacpaas.storage.IConcept;
import ru.dvo.iacp.is.iacpaas.storage.IConceptInt;
import ru.dvo.iacp.is.iacpaas.ui.exceptions.UiException;
import ru.dvo.iacp.is.iacpaas.utils.DataConverter;
import ru.dvo.iacp.is.iacpaas.utils.ParamChecker;

public class UiBuildHelperJSON {
    private int elementCount = 0;
    private static final String wrongParameterClass = "Parameter klass and/or hint must be either null or of class String or IConcept";
    private static final int maxUIElementsCount = 4000;
    private static final Random randomJsIdGenerator = new Random();
    private static final String confDefaultMsg = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b?";
    private static final Color white = new Color(255, 255, 255);
    private static final Color black = new Color(0, 0, 0);
    public static final String CLASS_ATTRIBUTE = "clas";
    public static final String HINT_ATTRIBUTE = "titl";
    public static final String ID_ATTRIBUTE = "id";
    public static final String WIDTH_ATTRIBUTE = "iacpaas-width";
    public static final String HEIGHT_ATTRIBUTE = "iacpaas-height";
    public static final String SPLIT_POSITION_ATTRIBUTE = "iacpaas-split-position";

    public Json jadditionalParams(Map<String, Object> params) {
        Json ie = this.jcreateUiElement("APr", null, null, null, null);
        this.jaddAdditionalAttributes(ie, params);
        return ie;
    }

    public Json jupload(String name, String label, String message, Map<String, Object> params) {
        return this.jupload(name, label, message, null, params);
    }

    public Json jupload(String name, String label, String message, String mime, Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("#buttonText", label);
        if (null != message && !"".equals(message.trim())) {
            params.put("#messageText", message);
        }
        if (null != mime && !"".equals(mime.trim())) {
            params.put("accept", mime.trim());
        }
        return this.jcreateUiElement("UpB", name, null, params, null);
    }

    public Json jbuttonDisabled(String label, String hint) {
        return this.jcreateUiElement("Btn", label, this.params("act", "", "icon", false, HINT_ATTRIBUTE, hint, "unav", true), null, null);
    }

    public Json jbutton(String label) {
        return this.jbutton(label, label);
    }

    public Json jbutton(String label, String actionParamValue) {
        return this.jbutton(label, actionParamValue, null, false, false);
    }

    public Json jbutton(String label, String actionParamValue, String formId, boolean validate, boolean confirmation) {
        return this.jbutton(label, actionParamValue, formId, validate, confirmation ? confDefaultMsg : null);
    }

    public Json jbutton(String label, String actionParamValue, String formId, boolean validate, String confirmationText) {
        return this.jcreateUiElement("Btn", label, this.params("act", actionParamValue, "fid", formId, "icon", false, "chck", validate, "cont", confirmationText), null, null);
    }

    public Json jreset(String label) {
        return this.jcreateUiElement("Btn", label, this.params("icon", false), this.params("type", "reset"), null);
    }

    public Json jcheckbox(String label, boolean checked, boolean disabled, Object hint) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            return this.jcreateUiElement("Chk", label, null, this.params("chkd", checked, "iavl", disabled, HINT_ATTRIBUTE, hint), null);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jcheckbox(String label, String name, String value, boolean checked, boolean disabled, Object hint) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            return this.jcreateUiElement("Chk", label, null, this.params("chkd", checked, "iavl", disabled, "name", name, "val", value, HINT_ATTRIBUTE, hint), null);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jjs(String agentInternalName, String filename, int width, int height, Map<String, Object> params) {
        return this.jcreateUiElement("JSc", null, this.params("file", agentInternalName + "/" + filename, "wid", width, "hei", height, ID_ATTRIBUTE, randomJsIdGenerator.nextLong()), params, null);
    }

    public Json jform(Json ... elements) {
        return this.jform((String)null, elements);
    }

    public Json jform(String formId, Json ... elements) {
        return this.jcreateUiElement("Frm", null, this.params("fid", formId), null, elements);
    }

    public Json jiconButton(Object klass, String actionOnClick, Object hint, Map<String, Object> params) throws UiException {
        return this.jiconButton(klass, actionOnClick, hint, false, params);
    }

    public Json jiconButton(Object klass, String actionOnClick, Object hint, boolean confirmation, Map<String, Object> params) throws UiException {
        return this.jiconButton(klass, actionOnClick, hint, confirmation ? confDefaultMsg : null, params);
    }

    public Json jiconButton(Object klass, String actionOnClick, Object hint, String confirmationText, Map<String, Object> params) throws UiException {
        if ((klass == null || klass instanceof String || klass instanceof IConcept) && (hint == null || hint instanceof String || hint instanceof IConcept)) {
            Json ie = this.jcreateUiElement("Btn", null, this.params("act", actionOnClick, "icon", true, "cont", confirmationText), this.params(CLASS_ATTRIBUTE, klass, HINT_ATTRIBUTE, hint), null);
            this.jaddAdditionalAttributes(ie, params);
            return ie;
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jiconButton(Object klass, String actionOnClick, Object hint, String prompt, String dataName, Map<String, Object> params) throws UiException {
        if ((klass == null || klass instanceof String || klass instanceof IConcept) && (hint == null || hint instanceof String || hint instanceof IConcept)) {
            Json ie = this.jcreateUiElement("Btn", null, this.params("act", actionOnClick, "icon", true, "ptxt", prompt, "pnam", dataName), this.params(CLASS_ATTRIBUTE, klass, HINT_ATTRIBUTE, hint), null);
            this.jaddAdditionalAttributes(ie, params);
            return ie;
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jiconButtonDisabled(Object klass, Object hint) throws UiException {
        if ((klass == null || klass instanceof String || klass instanceof IConcept) && (hint == null || hint instanceof String || hint instanceof IConcept)) {
            return this.jcreateUiElement("Btn", null, this.params("act", "", "icon", true, "conf", false, "unav", true), this.params(CLASS_ATTRIBUTE, klass, HINT_ATTRIBUTE, hint), null);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jlink(String label, Map<String, Object> params) throws UiException {
        return this.jlink(label, null, params);
    }

    public Json jlink(String label, Object hint, Map<String, Object> params) throws UiException {
        return this.jlink(label, hint, false, params);
    }

    public Json jlink(String label, Object hint, boolean confirmation, Map<String, Object> params) throws UiException {
        return this.jlink(label, hint, confirmation ? confDefaultMsg : null, params);
    }

    public Json jlink(String label, Object hint, String confirmationText, Map<String, Object> params) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            Json ie = this.jcreateUiElement("Lnk", label, this.params("type", "iLnk", "cont", confirmationText), this.params(HINT_ATTRIBUTE, hint), null);
            this.jaddAdditionalAttributes(ie, params);
            return ie;
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jextlink(String label, Object hint, String address) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            Json ie = this.jcreateUiElement("Lnk", label, this.params("type", "eLnk", "addr", address), this.params(HINT_ATTRIBUTE, hint), null);
            this.jaddAdditionalAttributes(ie, null);
            return ie;
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jlist(Json ... elements) {
        return this.jcreateUiElement("Lst", null, null, null, elements);
    }

    public Json jlistbox(String label, String ... values) {
        return this.jlistbox(label, false, null, values);
    }

    public Json jlistbox(String label, boolean required, String[] selectedValues, String ... values) {
        Json ie = this.jcreateUiElement("Sel", label + "[]", this.params("need", required), null, null);
        if (selectedValues == null) {
            selectedValues = new String[]{};
        }
        ie.at("atrs").set("mcho", (Object)true);
        Json variants = Json.array();
        ie.set("vrts", variants);
        for (String value : values) {
            Json var = Json.object();
            var.set("val", (Object)value);
            var.set("sel", (Object)ParamChecker.equalsToSome((String)value, (String[])selectedValues));
            variants.add(var);
        }
        return ie;
    }

    public Json janchor(Json element) {
        return this.jcreateUiElement("Anc", null, null, null, new Json[]{element});
    }

    public Json jblocks(Json ... elements) {
        return this.jcreateUiElement("Blk", null, null, null, elements);
    }

    public Json jparagraphs(Json ... elements) {
        return this.jcreateUiElement("Par", null, null, null, elements);
    }

    public Json jradiobutton(String label, boolean checked, boolean required, String groupName, String value) {
        return this.jcreateUiElement("Rbt", label, this.params("need", required), this.params("chkd", checked, "name", groupName, "val", value), null);
    }

    public Json jradiobutton(String label, boolean checked, boolean required, boolean disabled, String groupName, String value, Object hint) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            return this.jcreateUiElement("Rbt", label, this.params("need", required), this.params("chkd", checked, "iavl", disabled, "name", groupName, "val", value, HINT_ATTRIBUTE, hint), null);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jsec(Json ... elements) {
        return this.jcreateUiElement("Sec", null, null, null, elements);
    }

    public Json jsec(Object klass, Object hint, Json ... elements) throws UiException {
        if ((klass == null || klass instanceof IConcept || klass instanceof String) && (hint == null || hint instanceof IConcept || hint instanceof String)) {
            return this.jcreateUiElement("Sec", null, null, this.params(CLASS_ATTRIBUTE, klass, HINT_ATTRIBUTE, hint), elements);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jseq(Json ... elements) {
        return this.jcreateUiElement("Seq", null, null, null, elements);
    }

    public Json jseq(Object klass, Object hint, Json ... elements) throws UiException {
        if ((klass == null || klass instanceof IConcept || klass instanceof String) && (hint == null || hint instanceof IConcept || hint instanceof String)) {
            return this.jcreateUiElement("Seq", null, null, this.params(CLASS_ATTRIBUTE, klass, HINT_ATTRIBUTE, hint), elements);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jselect(String label, String ... values) {
        return this.jselect(label, null, false, values);
    }

    public Json jselect(String label, String selectedValue, boolean disabled, String ... values) {
        Json ie = this.jcreateUiElement("Sel", label, this.params("unav", disabled), null, null);
        String sv = selectedValue == null ? "" : selectedValue;
        ie.at("atrs").set("mcho", (Object)false);
        Json vars = Json.array();
        ie.at("atrs").set("vrts", vars);
        for (String value : values) {
            Json var = Json.object();
            var.set("val", (Object)value);
            var.set("sel", (Object)sv.equals(value));
            vars.add(var);
        }
        return ie;
    }

    public Json jselect(String label, Json ... elements) throws UiException {
        return this.jselect(label, (Object)null, elements);
    }

    public Json jselect(String label, Object hint, Json ... elements) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            return this.jcreateUiElement("Sel", label, null, this.params(HINT_ATTRIBUTE, hint), elements);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jselect(String label, Object hint, boolean disabled, Json ... elements) throws UiException {
        if (hint == null || hint instanceof IConcept || hint instanceof String) {
            return this.jcreateUiElement("Sel", label, this.params("unav", disabled), this.params(HINT_ATTRIBUTE, hint), elements);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json joptgroup(String label, Json ... elements) throws UiException {
        return this.joptgroup(null, label, elements);
    }

    public Json joptgroup(Object klass, String label, Json ... elements) throws UiException {
        if (klass == null || klass instanceof IConcept || klass instanceof String) {
            return this.jcreateUiElement("Grp", label, null, klass != null ? this.params(CLASS_ATTRIBUTE, klass) : null, elements);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json joption(String label, String value, Object hint, boolean selected) throws UiException {
        if (hint == null || hint instanceof String || hint instanceof IConcept) {
            Json ie = this.jcreateUiElement("Opt", label, null, this.params(HINT_ATTRIBUTE, hint), null);
            this.jaddAdditionalAttributes(ie, this.params("val", value, "sel", selected));
            return ie;
        }
        throw new UiException(wrongParameterClass);
    }

    public Json joption(String label, String value, Object hint) throws UiException {
        return this.joption(label, value, hint, false);
    }

    public Json jspace() {
        return this.jcreateUiElement("Spc", null, null, null, null);
    }

    public Json jtext(Object text) throws UiException {
        return this.jtext(text, null);
    }

    public Json jtext(Object text, Object hint) throws UiException {
        if (hint == null || hint instanceof String || hint instanceof IConcept && text == null || text instanceof String || text instanceof IConcept) {
            return this.jcreateUiElement("Lbl", null, this.params("text", text), this.params(HINT_ATTRIBUTE, hint), null);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jtextfield(String label) {
        return this.jtextfield(label, null, false, false, false, false);
    }

    public Json jtextfield(String label, String text) {
        return this.jtextfield(label, text, false, false, false, false);
    }

    public Json jtextfield(String label, String text, boolean required, boolean disabled) {
        return this.jtextfield(label, text, false, required, disabled, false);
    }

    public Json jtextfield(String label, String text, boolean required, boolean disabled, boolean focused) {
        return this.jtextfield(label, text, false, required, disabled, focused);
    }

    public Json jtextfield(String label, String text, boolean required) {
        return this.jtextfield(label, text, false, required, false, false);
    }

    private Json jtextfield(String label, String text, boolean multiline, boolean required, boolean disabled, boolean focused) {
        return this.jcreateUiElement("Txt", label, this.params("text", text, "mlin", multiline, "need", required, "unav", disabled, "afoc", focused), null, null);
    }

    public Json jtextarea(String label) {
        return this.jtextfield(label, null, true, false, false, false);
    }

    public Json jtextarea(String label, String text, boolean required) {
        return this.jtextfield(label, text, true, required, false, false);
    }

    public Json jtextarea(String label, String text, boolean required, boolean focused) {
        return this.jtextfield(label, text, true, required, false, focused);
    }

    public Json jwikilink(String articleLabel) {
        return this.jwikilink(articleLabel, articleLabel, null);
    }

    public Json jwikilink(String articleLabel, String visibleTitle) {
        return this.jwikilink(articleLabel, visibleTitle, null);
    }

    public Json jwikilink(String articleLabel, Map<String, Object> params) {
        return this.jwikilink(articleLabel, articleLabel, params);
    }

    public Json jwikilink(String articleLabel, String visibleTitle, Map<String, Object> params) {
        Json ie = this.jcreateUiElement("Lnk", visibleTitle, this.params("type", "wLnk", "link", articleLabel), null, null);
        this.jaddAdditionalAttributes(ie, params);
        return ie;
    }

    public Json jvertsplit(Json left, Json right) {
        return this.jsplit(left, right, true);
    }

    public Json jhorsplit(Json up, Json bottom) {
        return this.jsplit(up, bottom, false);
    }

    public Json jsplit(Json first, Json second, boolean isVertical) {
        return this.jcreateUiElement("Sep", null, this.params("ori", isVertical), null, new Json[]{first, second});
    }

    public Json jtable(Json ... rows) throws UiException {
        return this.jtable(null, "left", 1, black, white, "0", 0, "0", "0", true, rows);
    }

    public Json jtable(String hint, String hAlign, int border, Color borderColor, Color backColor, String cellPadding, int cellSpacing, String height, String width, boolean showFrame, Json ... rows) throws UiException {
        if (!ParamChecker.equalsToSome((String)hAlign.toUpperCase(Locale.ROOT), (String[])new String[]{"CENTER", "LEFT", "RIGHT"})) {
            throw new UiException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 hAlign \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0434\u043d\u043e\u0439 \u0438\u0445 \u0441\u0442\u0440\u043e\u043a\u043e\u0432\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442: center, left, right");
        }
        int intCellPadding = this.checkAndGetInt("cellPadding", cellPadding);
        int intHeight = this.checkAndGetInt("height", height);
        int intWidth = this.checkAndGetInt("width", width);
        return this.jcreateUiElement("Tbl", null, this.params("alig", hAlign, "bord", border, "boco", String.format("#%02x%02x%02x", borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue()), "baco", String.format("#%02x%02x%02x", backColor.getRed(), backColor.getGreen(), backColor.getBlue()), "cpad", intCellPadding >= 0 ? cellPadding : null, "cspc", cellSpacing >= 0 ? Integer.valueOf(cellSpacing) : null, "heit", intHeight < 1 ? height : null, "widt", intWidth < 1 ? width : null, "fram", showFrame), this.params(HINT_ATTRIBUTE, hint), rows);
    }

    public Json row(Json ... cells) throws UiException {
        Color white = new Color(255, 255, 255);
        Color black = new Color(0, 0, 0);
        return this.row(null, "left", "middle", black, white, cells);
    }

    public Json row(String hint, String hAlign, String vAlign, Color borderColor, Color backColor, Json ... cells) throws UiException {
        if (cells.length == 0) {
            throw new UiException("\u0412 \u0441\u0442\u0440\u043e\u043a\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044f\u0447\u0435\u0439\u043a\u0438, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 1 \u044f\u0447\u0435\u0439\u043a\u0438");
        }
        if (!ParamChecker.equalsToSome((String)hAlign.toUpperCase(Locale.ROOT), (String[])new String[]{"CENTER", "LEFT", "RIGHT"})) {
            throw new UiException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 hAlign \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0434\u043d\u043e\u0439 \u0438\u0445 \u0441\u0442\u0440\u043e\u043a\u043e\u0432\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442: center, left, right");
        }
        if (!ParamChecker.equalsToSome((String)vAlign.toUpperCase(Locale.ROOT), (String[])new String[]{"MIDDLE", "TOP", "BOTTOM", "BASELINE"})) {
            throw new UiException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 hAlign \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0434\u043d\u043e\u0439 \u0438\u0445 \u0441\u0442\u0440\u043e\u043a\u043e\u0432\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442: middle, top, bottom, baseline");
        }
        return this.jcreateUiElement("Row", null, this.params("alig", hAlign, "valg", vAlign, "baco", String.format("#%02x%02x%02x", backColor.getRed(), backColor.getGreen(), backColor.getBlue()), "boco", String.format("#%02x%02x%02x", borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue())), this.params(HINT_ATTRIBUTE, hint), cells);
    }

    public Json cell(Json uiElem) throws UiException {
        Color white = new Color(255, 255, 255);
        Color black = new Color(255, 255, 255);
        return this.cell(null, "left", "top", black, white, false, "0", "0", false, uiElem);
    }

    public Json cell(String hint, String hAlign, String vAlign, Color borderColor, Color backColor, boolean isHeader, String height, String width, boolean noWrap, Json uiElem) throws UiException {
        if (!ParamChecker.equalsToSome((String)hAlign.toUpperCase(Locale.ROOT), (String[])new String[]{"CENTER", "LEFT", "RIGHT"})) {
            throw new UiException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 hAlign \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0434\u043d\u043e\u0439 \u0438\u0445 \u0441\u0442\u0440\u043e\u043a\u043e\u0432\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442: center, left, right");
        }
        if (!ParamChecker.equalsToSome((String)vAlign.toUpperCase(Locale.ROOT), (String[])new String[]{"MIDDLE", "TOP", "BOTTOM", "BASELINE"})) {
            throw new UiException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 hAlign \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0434\u043d\u043e\u0439 \u0438\u0445 \u0441\u0442\u0440\u043e\u043a\u043e\u0432\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442: middle, top, bottom, baseline");
        }
        int intHeight = this.checkAndGetInt("height", height);
        int intWidth = this.checkAndGetInt("width", width);
        Json[] subElems = new Json[]{uiElem};
        return this.jcreateUiElement("Cel", null, this.params("alin", hAlign, "valg", vAlign, "baco", String.format("#%02x%02x%02x", backColor.getRed(), backColor.getGreen(), backColor.getBlue()), "heit", intHeight < 1 ? height : null, "widt", intWidth < 1 ? width : null, "head", isHeader, "nwrp", noWrap), this.params(HINT_ATTRIBUTE, hint), subElems);
    }

    private int checkAndGetInt(String name, String value) throws UiException {
        String tempStrVal = "";
        int intVal = 0;
        if (value.endsWith("%")) {
            tempStrVal = value.substring(0, value.length() - 1);
        }
        try {
            intVal = Integer.parseInt(tempStrVal);
        }
        catch (NumberFormatException ex) {
            throw new UiException("\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f " + name + " - \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u043e\u0435 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0438\u043b\u0438 \u043f\u0440\u043e\u0446\u0435\u043d\u0442");
        }
        return intVal;
    }

    public Json jtag(String name, Map<String, Object> params) {
        return this.jtag(name, params, null);
    }

    public Json jtag(String name, Map<String, Object> params, Json ... subElements) {
        Json ie = this.jcreateUiElement("Tag", null, null, null, subElements);
        ie.set("name", (Object)name);
        this.jaddAdditionalAttributes(ie, params);
        return ie;
    }

    public Json jscript(String text) {
        return this.jcreateUiElement("Scr", null, this.params("text", text), null, null);
    }

    public Json jdatetime(String label) {
        return this.jdatetime(label, null, false);
    }

    public Json jdatetime(String label, Date value, boolean disabled) {
        return this.jcreateUiElement("Dtl", label, this.params("val", value, "unav", disabled), null, null);
    }

    public Json jdate(String label) {
        return this.jdate(label, null, false);
    }

    public Json jdate(String label, Date value, boolean disabled) {
        return this.jcreateUiElement("Dat", label, this.params("val", value, "unav", disabled), null, null);
    }

    public Json jtime(String label) {
        return this.jtime(label, null, false);
    }

    public Json jtime(String label, Date value, boolean disabled) {
        return this.jcreateUiElement("Tme", label, this.params("val", value, "unav", disabled), null, null);
    }

    public Json jrealfield(String label) {
        return this.jrealfield(label, null, false, false);
    }

    public Json jrealfield(String label, String value, boolean disabled) {
        return this.jrealfield(label, value, disabled, false);
    }

    public Json jrealfield(String label, String value, boolean disabled, boolean required) {
        return this.jcreateUiElement("Num", label, this.params("val", value, "unav", disabled, "need", required), null, null);
    }

    public Json jintfield(String label) {
        return this.jintfield(label, null, false, false);
    }

    public Json jintfield(String label, String value, boolean disabled) {
        return this.jintfield(label, value, disabled, false);
    }

    public Json jintfield(String label, String value, boolean disabled, boolean required) {
        return this.jcreateUiElement("Int", label, this.params("val", value, "unav", disabled, "need", required), null, null);
    }

    public Json junfolder(String title, Json subElement) {
        return this.junfolder(title, false, subElement);
    }

    public Json junfolder(String title, boolean opened, Json subElement) {
        return this.jcreateUiElement("Det", null, this.params(HINT_ATTRIBUTE, title, "open", opened), null, new Json[]{subElement});
    }

    private Json jdecorateWithAttr(String name, Object value, Json ie) {
        if (ie.has("sats")) {
            ie.at("sats").set(name, this.convertVal(value));
        } else {
            HashMap<String, Object> paramAsMap = new HashMap<String, Object>();
            paramAsMap.put(name, value);
            Json attr = this.makeSomeAttributesOrEmpty(paramAsMap);
            ie.set("sats", attr);
        }
        return ie;
    }

    public Json jklass(Object klass, Json element) throws UiException {
        if (klass == null || klass instanceof IConcept || klass instanceof String) {
            return this.jdecorateWithAttr(CLASS_ATTRIBUTE, klass, element);
        }
        throw new UiException(wrongParameterClass);
    }

    public Json jid(String id, Json element) {
        return this.jdecorateWithAttr(ID_ATTRIBUTE, id, element);
    }

    public Json jwidth(int widthInPixel, Json element) {
        return this.jdecorateWithAttr(WIDTH_ATTRIBUTE, Integer.toString(widthInPixel), element);
    }

    public Json jwidth(String width, Json element) {
        return this.jdecorateWithAttr(WIDTH_ATTRIBUTE, width, element);
    }

    public Json jheight(int heightInPixel, Json element) {
        return this.jdecorateWithAttr(HEIGHT_ATTRIBUTE, Integer.toString(heightInPixel), element);
    }

    public Json jheight(String height, Json element) {
        return this.jdecorateWithAttr(HEIGHT_ATTRIBUTE, height, element);
    }

    public Json jsplitPosition(int splitInPixel, Json element) {
        return this.jdecorateWithAttr(SPLIT_POSITION_ATTRIBUTE, Integer.toString(splitInPixel), element);
    }

    public Json jsplitPosition(String split, Json element) {
        return this.jdecorateWithAttr(SPLIT_POSITION_ATTRIBUTE, split, element);
    }

    public Json graphInterface(IConcept ie) {
        return this.jcreateUiElement("Grf", null, this.params("cid", ((IConceptInt)ie).getId()), null, null);
    }

    public Map<String, Object> params(Object ... objs) {
        assert (objs.length % 2 == 0);
        HashMap<String, Object> result = new HashMap<String, Object>(objs.length / 2);
        for (int i = 0; i < objs.length; i += 2) {
            Object p = objs[i + 1];
            if (p == null) continue;
            result.put(objs[i].toString(), p);
        }
        return result;
    }

    private Json jcreateUiElement(String type, String label, Map<String, Object> attrs, Map<String, Object> sysAttrs, Json[] subElements) {
        Json sats;
        Json ie = Json.object();
        ++this.elementCount;
        if (label != null) {
            ie.set("labl", (Object)label);
        }
        if (subElements != null && subElements.length > 0) {
            Json subEls = Json.array();
            for (Json el : subElements) {
                if (el == null) continue;
                subEls.add(el);
            }
            ie.set("iels", subEls);
        }
        if ((sats = this.makeSomeAttributesOrEmpty(sysAttrs)) != null) {
            ie.set("sats", sats);
        }
        ie.set("type", (Object)type);
        Json atrs = this.makeSomeAttributesOrEmpty(attrs);
        if (atrs != null) {
            ie.set("atrs", atrs);
        }
        return ie;
    }

    private Json makeSomeAttributesOrEmpty(Map<String, Object> someAttrs) {
        Json atrs = Json.object();
        if (someAttrs != null && !someAttrs.isEmpty()) {
            for (Map.Entry<String, Object> entry : someAttrs.entrySet()) {
                Object val = entry.getValue();
                atrs.set(entry.getKey(), this.convertVal(val));
            }
        }
        return atrs;
    }

    private Object convertVal(Object val) {
        if (val instanceof Number) {
            return val;
        }
        if (val instanceof IConcept) {
            return "Unsuported type for VALUE - IConcept";
        }
        if (val instanceof Boolean) {
            return val;
        }
        if (val instanceof Date) {
            return DataConverter.date2strNoSec((Date)((Date)val));
        }
        return val.toString();
    }

    private void jaddAdditionalAttributes(Json ie, Map<String, Object> params) {
        Json aats = this.makeSomeAttributesOrEmpty(params);
        if (aats != null) {
            ie.set("aats", aats);
        }
    }

    public boolean jmaxUISizeReached() {
        return this.elementCount > 4000;
    }

    public int getElementCount() {
        return this.elementCount;
    }
}

