/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.log4j.web.util;

import grails.util.Environment;
import groovy.util.ConfigObject;
import java.lang.reflect.Method;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.LogLog;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.codehaus.groovy.grails.plugins.log4j.Log4jConfig;

public class Log4jConfigListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Object grailsApplication = this.createGrailsApplication(contextClassLoader);
            ConfigObject co = this.getConfig(grailsApplication);
            Log4jConfig.initialize(co);
        }
        catch (Throwable e) {
            LogLog.error((String)("Error initializing log4j: " + e.getMessage()), (Throwable)e);
        }
    }

    private Object createGrailsApplication(ClassLoader contextClassLoader) {
        try {
            Class<?> applicationClass = contextClassLoader.loadClass("org.codehaus.groovy.grails.commons.DefaultGrailsApplication");
            return applicationClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Error instantiating GrailsApplication during logging initialization: " + e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PluginException("Error instantiating GrailsApplication during logging initialization: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Error instantiating GrailsApplication during logging initialization: " + e.getMessage(), (Throwable)e);
        }
    }

    private ConfigObject getConfig(Object grailsApplication) {
        try {
            Method getConfigMethod = grailsApplication.getClass().getMethod("getConfig", new Class[0]);
            return (ConfigObject)getConfigMethod.invoke(grailsApplication, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (Environment.getCurrent() != Environment.DEVELOPMENT) {
            LogManager.shutdown();
        }
    }
}

