/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.SiteMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class SiteStageMojo
extends SiteMojo {
    protected File stagingDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String structureParentProject;
        String structureProject = SiteStageMojo.getStructure(this.project, false);
        if (structureProject == null) {
            throw new MojoExecutionException("Missing site information.");
        }
        this.outputDirectory = new File(this.stagingDirectory, structureProject);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        String outputRelativePath = PathTool.getRelativePath((String)this.stagingDirectory.getAbsolutePath(), (String)new File(this.outputDirectory, "dummy.html").getAbsolutePath());
        this.project.setUrl(outputRelativePath + "/" + structureProject);
        MavenProject parent = this.getParentProject(this.project);
        if (parent != null && (structureParentProject = SiteStageMojo.getStructure(parent, true)) != null) {
            parent.setUrl(outputRelativePath + "/" + structureParentProject);
        }
        if (this.reactorProjects != null && this.reactorProjects.size() > 1) {
            Iterator reactorItr = this.reactorProjects.iterator();
            while (reactorItr.hasNext()) {
                MavenProject reactorProject = (MavenProject)reactorItr.next();
                if (reactorProject == null || reactorProject.getParent() == null || !this.project.getArtifactId().equals(reactorProject.getParent().getArtifactId())) continue;
                String structureReactorProject = SiteStageMojo.getStructure(reactorProject, false);
                reactorProject.setUrl(outputRelativePath + "/" + structureReactorProject);
            }
        }
        super.execute();
    }

    protected static String getStructure(MavenProject project, boolean ignoreMissingSiteUrl) throws MojoFailureException {
        if (project.getDistributionManagement() == null) {
            String hierarchy = project.getName();
            for (MavenProject parent = project.getParent(); parent != null; parent = parent.getParent()) {
                hierarchy = parent.getName() + "/" + hierarchy;
            }
            return hierarchy;
        }
        Site site = project.getDistributionManagement().getSite();
        if (site == null) {
            if (!ignoreMissingSiteUrl) {
                throw new MojoFailureException("Missing site information in the distribution management element in the project: '" + project.getName() + "'.");
            }
            return null;
        }
        if (StringUtils.isEmpty((String)site.getUrl())) {
            if (!ignoreMissingSiteUrl) {
                throw new MojoFailureException("The URL in the site is missing in the project descriptor.");
            }
            return null;
        }
        Repository repository = new Repository(site.getId(), site.getUrl());
        if (StringUtils.isEmpty((String)repository.getBasedir())) {
            return repository.getHost();
        }
        if (repository.getBasedir().startsWith("/")) {
            return repository.getHost() + repository.getBasedir();
        }
        return repository.getHost() + "/" + repository.getBasedir();
    }
}

