/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;

public class UnnecessaryFullyQualifiedNameRule
extends AbstractJavaRule {
    private List<ASTImportDeclaration> imports = new ArrayList<ASTImportDeclaration>();

    public UnnecessaryFullyQualifiedNameRule() {
        super.addRuleChainVisit(ASTCompilationUnit.class);
        super.addRuleChainVisit(ASTImportDeclaration.class);
        super.addRuleChainVisit(ASTClassOrInterfaceType.class);
        super.addRuleChainVisit(ASTName.class);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        this.imports.add(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        if (node.getImage().indexOf(46) < 0) {
            return data;
        }
        this.checkImports(node, data);
        return data;
    }

    @Override
    public Object visit(ASTName node, Object data) {
        if (!(node.jjtGetParent() instanceof ASTImportDeclaration) && !(node.jjtGetParent() instanceof ASTPackageDeclaration)) {
            if (node.getImage().indexOf(46) < 0) {
                return data;
            }
            this.checkImports(node, data);
        }
        return data;
    }

    private boolean declarationMatches(ASTImportDeclaration decl, String name) {
        return name.startsWith(decl.getImportedName()) && name.lastIndexOf(46) == decl.getImportedName().length();
    }

    private void checkImports(JavaNode node, Object data) {
        ASTImportDeclaration firstMatch;
        String name = node.getImage();
        ArrayList<ASTImportDeclaration> matches = new ArrayList<ASTImportDeclaration>();
        for (ASTImportDeclaration importDeclaration : this.imports) {
            if (!importDeclaration.isImportOnDemand() && name.equals(importDeclaration.getImportedName())) {
                matches.add(importDeclaration);
                continue;
            }
            if (!this.declarationMatches(importDeclaration, name)) continue;
            matches.add(importDeclaration);
        }
        if (matches.isEmpty()) {
            for (ASTImportDeclaration importDeclaration : this.imports) {
                if (!importDeclaration.isStatic()) continue;
                String[] importParts = importDeclaration.getImportedName().split("\\.");
                String[] nameParts = name.split("\\.");
                if (importDeclaration.isImportOnDemand()) {
                    if (!nameParts[nameParts.length - 2].equals(importParts[importParts.length - 1])) continue;
                    matches.add(importDeclaration);
                    continue;
                }
                if (!nameParts[nameParts.length - 1].equals(importParts[importParts.length - 1]) || !nameParts[nameParts.length - 2].equals(importParts[importParts.length - 2])) continue;
                matches.add(importDeclaration);
            }
        }
        if (!matches.isEmpty() && !this.isAvoidingConflict(node, name, firstMatch = (ASTImportDeclaration)matches.get(0))) {
            String importStr = firstMatch.getImportedName() + (firstMatch.isImportOnDemand() ? ".*" : "");
            String type = firstMatch.isStatic() ? "static " : "";
            this.addViolation(data, (Node)node, new Object[]{node.getImage(), importStr, type});
        }
    }

    private boolean isAvoidingConflict(JavaNode node, String name, ASTImportDeclaration firstMatch) {
        if (firstMatch.isImportOnDemand() && firstMatch.isStatic()) {
            String methodCalled = name.substring(name.indexOf(46) + 1);
            for (ASTImportDeclaration aSTImportDeclaration : this.imports) {
                if (Objects.equals(aSTImportDeclaration, firstMatch) || !aSTImportDeclaration.isStatic() || this.declarationMatches(firstMatch, aSTImportDeclaration.getImportedName())) continue;
                if (aSTImportDeclaration.isImportOnDemand()) {
                    if (aSTImportDeclaration.getType() == null) continue;
                    for (Method m : aSTImportDeclaration.getType().getMethods()) {
                        if (!m.getName().equals(methodCalled)) continue;
                        return true;
                    }
                    continue;
                }
                if (!aSTImportDeclaration.getImportedName().endsWith(methodCalled)) continue;
                return true;
            }
        }
        String unqualifiedName = name.substring(name.lastIndexOf(46) + 1);
        int unqualifiedNameLength = unqualifiedName.length();
        if (firstMatch.isImportOnDemand() && !firstMatch.isStatic()) {
            for (ASTImportDeclaration importDeclaration : this.imports) {
                if (importDeclaration == firstMatch || importDeclaration.isStatic() || importDeclaration.isImportOnDemand() || importDeclaration.getPackageName().equals(firstMatch.getPackageName()) || !importDeclaration.getImportedSimpleName().equals(unqualifiedName)) continue;
                return true;
            }
        }
        Set<String> set = ((SourceFileScope)node.getScope().getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().keySet();
        for (String qualified : set) {
            int fullLength = qualified.length();
            if (!qualified.endsWith(unqualifiedName) || fullLength != unqualifiedNameLength && qualified.charAt(fullLength - unqualifiedNameLength - 1) != '.') continue;
            return true;
        }
        return false;
    }
}

