/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.lang;

import org.checkerframework.checker.index.qual.PolyIndex;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.PolyValue;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.AnnotatedFor;
import jdk.internal.HotSpotIntrinsicCandidate;

@AnnotatedFor({ "nullness", "index", "value" })
public final class Short extends Number implements Comparable<Short> {

    @IntVal(-32768)
    public static final short MIN_VALUE;

    @Positive
    @IntVal(32767)
    public static final short MAX_VALUE;

    @SuppressWarnings("unchecked")
    public static final Class<Short> TYPE;

    @SideEffectFree
    @StaticallyExecutable
    @ArrayLen({ 1, 2, 3, 4, 5, 6 })
    public static String toString(short s);

    @Pure
    @StaticallyExecutable
    public static short parseShort(String s, @Positive @IntRange(from = 2, to = 36) int radix) throws NumberFormatException;

    @Pure
    @StaticallyExecutable
    public static short parseShort(String s) throws NumberFormatException;

    @SideEffectFree
    @StaticallyExecutable
    public static Short valueOf(String s, @Positive @IntRange(from = 2, to = 36) int radix) throws NumberFormatException;

    @SideEffectFree
    @StaticallyExecutable
    public static Short valueOf(String s) throws NumberFormatException;

    private static class ShortCache {
    }

    @SideEffectFree
    @StaticallyExecutable
    @HotSpotIntrinsicCandidate
    @PolyIndex
    @PolyValue
    public static Short valueOf(@PolyIndex @PolyValue short s);

    @SideEffectFree
    @StaticallyExecutable
    public static Short decode(String nm) throws NumberFormatException;

    @SideEffectFree
    @StaticallyExecutable
    @Deprecated()
    @PolyIndex
    public Short(@PolyIndex short value) {
    }

    @SideEffectFree
    @StaticallyExecutable
    @Deprecated()
    public Short(String s) throws NumberFormatException {
    }

    @Pure
    @StaticallyExecutable
    @PolyIndex
    @PolyValue
    public byte byteValue(@PolyIndex @PolyValue Short this);

    @Pure
    @StaticallyExecutable
    @HotSpotIntrinsicCandidate
    @PolyIndex
    @PolyValue
    public short shortValue(@PolyIndex @PolyValue Short this);

    @Pure
    @StaticallyExecutable
    @PolyIndex
    @PolyValue
    public int intValue(@PolyIndex @PolyValue Short this);

    @Pure
    @StaticallyExecutable
    @PolyIndex
    @PolyValue
    public long longValue(@PolyIndex @PolyValue Short this);

    @Pure
    @StaticallyExecutable
    @PolyValue
    public float floatValue(@PolyValue Short this);

    @Pure
    @StaticallyExecutable
    @PolyValue
    public double doubleValue(@PolyValue Short this);

    @SideEffectFree
    @StaticallyExecutable
    @ArrayLen({ 1, 2, 3, 4, 5, 6 })
    public String toString();

    @Pure
    @StaticallyExecutable
    @Override
    public int hashCode();

    @Pure
    @StaticallyExecutable
    public static int hashCode(short value);

    @Pure
    @StaticallyExecutable
    public boolean equals(@Nullable Object obj);

    @Pure
    @StaticallyExecutable
    public int compareTo(Short anotherShort);

    @Pure
    @StaticallyExecutable
    public static int compare(short x, short y);

    @Pure
    @StaticallyExecutable
    public static int compareUnsigned(short x, short y);

    @Positive
    @IntVal(16)
    public static final int SIZE;

    @IntVal(2)
    public static final int BYTES;

    @Pure
    @StaticallyExecutable
    @HotSpotIntrinsicCandidate
    public static short reverseBytes(short i);

    @Pure
    @StaticallyExecutable
    public static int toUnsignedInt(short x);

    @Pure
    @StaticallyExecutable
    public static long toUnsignedLong(short x);
}
