/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Page;

/**
 * Links to a given page via an object implementing the IPageLink delayed linking interface.
 * PageLinks can be constructed directly with an IPageLink interface or with a Page Class object. In
 * the latter case, an IPageLink implementation is provided which constructs a Page of the given
 * class when the link is clicked. A default no-args constructor must be available in this case or a
 * WicketRuntimeException will be thrown when Wicket fails to instantiate the class.
 * 
 * TODO 1.5: remove
 * 
 * @see IPageLink
 * @author Jonathan Locke
 * @param <T>
 *            type of model object
 * 
 * @deprecated use BookmarkabpePageLink or Link instead
 * 
 */
@Deprecated
public class PageLink<T> extends Link<T>
{
	private static final long serialVersionUID = 1L;

	/** The delayed linking Page source. */
	private final IPageLink pageLink;

	/**
	 * Constructs a link that instantiates the given Page class when the link is clicked. The
	 * instantiated Page is used to render a response to the user.
	 * 
	 * @param <C>
	 * 
	 * @param id
	 *            See Component
	 * @param c
	 *            Page class
	 */
	public <C extends Page> PageLink(final String id, final Class<C> c)
	{
		super(id);

		// Ensure that c is a subclass of Page
		if (!Page.class.isAssignableFrom(c))
		{
			throw new IllegalArgumentException("Class " + c + " is not a subclass of Page");
		}

		pageLink = new IPageLink()
		{
			private static final long serialVersionUID = 1L;

			public Page getPage()
			{
				// Create page using page factory
				return getSession().getPageFactory().newPage(c);
			}

			public Class<? extends Page> getPageIdentity()
			{
				return c;
			}
		};
	}

	/**
	 * Retrieves the class of page this link links to.
	 * 
	 * @return page of class
	 */
	public Class<? extends Page> getPageClass()
	{
		return pageLink.getPageIdentity();
	}

	/**
	 * This constructor is ideal for constructing pages lazily.
	 * 
	 * Constructs a link which invokes the getPage() method of the IPageLink interface when the link
	 * is clicked. Whatever Page objects is returned by this method will be rendered back to the
	 * user.
	 * 
	 * @param id
	 *            See Component
	 * @param pageLink
	 *            An implementation of IPageLink which will create the page linked to if and when
	 *            this hyperlink is clicked at a later time.
	 */
	public PageLink(final String id, final IPageLink pageLink)
	{
		super(id);
		this.pageLink = pageLink;
	}

	/**
	 * This constructor is ideal if a Page object was passed in from a previous Page. Construct a
	 * link to the Page. Warning: DO NOT use this for constructing links to pages you didn't already
	 * have an instance of. This constructor is strongly discouraged for anything other than linking
	 * back to the same page.
	 * 
	 * @param id
	 *            See component
	 * @param page
	 *            The page
	 * @deprecated rather than using this class/ constructor, use normal {@link Link links} and call
	 *             setResponsePage in their {@link Link#onClick() onClick} methods.
	 */
	@Deprecated
	public PageLink(final String id, final Page page)
	{
		super(id);

		pageLink = new IPageLink()
		{
			private static final long serialVersionUID = 1L;

			public Page getPage()
			{
				// Create page using page factory
				return page;
			}

			public Class<? extends Page> getPageIdentity()
			{
				return page.getClass();
			}
		};
	}

	/**
	 * Returns true if the given page is of the same class as the (delayed) destination of this page
	 * link.
	 * 
	 * @see org.apache.wicket.markup.html.link.Link#linksTo(org.apache.wicket.Page)
	 */
	@Override
	public boolean linksTo(final Page page)
	{
		return page.getClass() == pageLink.getPageIdentity();
	}

	/**
	 * Handles a link click by asking for a concrete Page instance through the IPageLink.getPage()
	 * delayed linking interface. This call will normally cause the destination page to be created.
	 * 
	 * @see org.apache.wicket.markup.html.link.Link#onClick()
	 */
	@Override
	public void onClick()
	{
		// Set page source's page as response page
		setResponsePage(pageLink.getPage());
	}
}
