/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopologicalSort {
    static final boolean DEBUG = SystemProperties.getBoolean("tsort.debug");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> List<E> sortByCallGraph(Collection<E> elements, OutEdges<E> outEdges) {
        Profiler profile = Global.getAnalysisCache().getProfiler();
        profile.start(TopologicalSort.class);
        try {
            Worker2<E> instance = new Worker2<E>(elements, outEdges);
            List list = instance.compute();
            return list;
        }
        finally {
            profile.end(TopologicalSort.class);
        }
    }

    public static <E> void countBadEdges(List<E> elements, OutEdges<E> outEdges) {
        if (!DEBUG) {
            return;
        }
        HashSet<E> seen = new HashSet<E>();
        HashSet<E> all = new HashSet<E>(elements);
        int result = 0;
        int total = 0;
        for (E e : elements) {
            for (E e2 : outEdges.getOutEdges(e)) {
                if (e == e2 || !all.contains(e2) || outEdges.getOutEdges(e2).contains(e)) continue;
                ++total;
                if (seen.contains(e2)) continue;
                ++result;
            }
            seen.add(e);
        }
        System.out.println(" bad edges are " + result + "/" + total);
    }

    static class Worker2<E>
    implements SortAlgorithm<E> {
        OutEdges<E> outEdges;
        Set<E> consider = new HashSet();
        MultiMap<E, E> iEdges;
        MultiMap<E, E> oEdges;

        Worker2(Collection<E> consider, OutEdges<E> outEdges) {
            if (outEdges == null) {
                throw new IllegalArgumentException("outEdges must not be null");
            }
            this.consider = new LinkedHashSet<E>(consider);
            this.outEdges = outEdges;
        }

        private void removeVertex(E e) {
            Collection<E> outEdges = this.oEdges.get(e);
            Collection<E> inEdges = this.iEdges.get(e);
            for (E e2 : outEdges) {
                this.iEdges.remove(e2, e);
            }
            for (E e2 : inEdges) {
                this.oEdges.remove(e2, e);
            }
            this.iEdges.removeAll(e);
            this.oEdges.removeAll(e);
        }

        @Override
        public List<E> compute() {
            ArrayList<Object> doFirst = new ArrayList<Object>(this.consider.size());
            ArrayList<E> doLast = new ArrayList<E>(this.consider.size());
            HashSet<E> remaining = new HashSet<E>(this.consider);
            this.iEdges = new MultiMap(LinkedList.class);
            this.oEdges = new MultiMap(LinkedList.class);
            for (E e : this.consider) {
                for (E e2 : this.outEdges.getOutEdges(e)) {
                    if (e == e2 || !this.consider.contains(e2)) continue;
                    this.iEdges.add(e2, e);
                    this.oEdges.add(e, e2);
                }
            }
            for (E e : this.consider) {
                HashSet<E> both = new HashSet<E>(this.iEdges.get(e));
                both.retainAll(this.oEdges.get(e));
                for (E e2 : both) {
                    this.iEdges.remove(e, e2);
                    this.oEdges.remove(e, e2);
                }
            }
            while (!remaining.isEmpty()) {
                boolean foundSomething = false;
                Object best = null;
                int bestScore = Integer.MIN_VALUE;
                Iterator<E> i = remaining.iterator();
                while (i.hasNext()) {
                    E e = i.next();
                    if (this.oEdges.get(e).isEmpty()) {
                        doFirst.add(e);
                        this.removeVertex(e);
                        if (DEBUG) {
                            System.out.println("do " + e + " first");
                        }
                        i.remove();
                        foundSomething = true;
                        continue;
                    }
                    if (this.iEdges.get(e).isEmpty()) {
                        doLast.add(e);
                        this.removeVertex(e);
                        if (DEBUG) {
                            System.out.println("do " + e + " last");
                        }
                        i.remove();
                        foundSomething = true;
                        continue;
                    }
                    int myScore = this.getScore(e);
                    if (bestScore >= myScore) continue;
                    bestScore = myScore;
                    best = e;
                }
                if (foundSomething) continue;
                if (DEBUG) {
                    System.out.println("do " + best + " first, reluctantly");
                    System.out.println("  score: " + bestScore);
                    System.out.println("  needs: " + this.oEdges.get(best));
                    System.out.println("  needed by: " + this.iEdges.get(best));
                }
                doFirst.add(best);
                this.removeVertex(best);
                remaining.remove(best);
            }
            Collections.reverse(doLast);
            doFirst.addAll(doLast);
            return doFirst;
        }

        private int getScore(E e) {
            int myScore = this.score(e);
            if (this.outEdges instanceof OutEdges2) {
                int score2 = ((OutEdges2)this.outEdges).score(e);
                if (score2 > 1) {
                    score2 += 11;
                }
                myScore = 5 * myScore + score2;
            }
            return myScore;
        }

        private int score(E e) {
            int myScore = 0;
            for (E e2 : this.oEdges.get(e)) {
                if (this.iEdges.get(e2).size() == 1) {
                    myScore -= 2;
                    continue;
                }
                --myScore;
            }
            for (E e2 : this.iEdges.get(e)) {
                if (this.oEdges.get(e2).size() == 1) {
                    myScore += 2;
                    continue;
                }
                ++myScore;
            }
            return myScore;
        }
    }

    static class Worker<E>
    implements SortAlgorithm<E> {
        OutEdges<E> outEdges;
        List<E> result;
        HashSet<E> visited = new HashSet();
        Set<E> consider = new HashSet();

        Worker(Collection<E> consider, OutEdges<E> outEdges) {
            this.consider = new LinkedHashSet<E>(consider);
            this.outEdges = outEdges;
            this.result = new ArrayList(consider.size());
        }

        @Override
        public List<E> compute() {
            for (E e : this.consider) {
                this.visit(e);
            }
            return this.result;
        }

        void visit(E e) {
            if (!this.consider.contains(e)) {
                return;
            }
            if (!this.visited.add(e)) {
                return;
            }
            for (E e2 : this.outEdges.getOutEdges(e)) {
                this.visit(e2);
            }
            this.result.add(e);
        }
    }

    static interface SortAlgorithm<E> {
        public List<E> compute();
    }

    public static class OutEdgesCache<E>
    implements OutEdges<E> {
        final Map<E, Collection<E>> map = new IdentityHashMap<E, Collection<E>>();
        final OutEdges<E> base;

        public OutEdgesCache(OutEdges<E> base) {
            this.base = base;
        }

        @Override
        public Collection<E> getOutEdges(E e) {
            Collection<E> result = this.map.get(e);
            if (result == null) {
                result = this.base.getOutEdges(e);
                this.map.put(e, result);
            }
            return result;
        }
    }

    public static interface OutEdges2<E>
    extends OutEdges<E> {
        public int score(E var1);
    }

    public static interface OutEdges<E> {
        public Collection<E> getOutEdges(E var1);
    }
}

