/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools;

import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.WillClose;

public class FilterAndCombineBitfieldPropertyDatabase {
    static final int FLAGS = 5;
    static Map<String, Status> classStatus = new HashMap<String, Status>();

    public static void main(String[] args) throws IOException {
        TreeMap<String, Integer> properties = new TreeMap<String, Integer>();
        TreeMap<String, Integer> accessFlags = new TreeMap<String, Integer>();
        if (args.length == 0) {
            FilterAndCombineBitfieldPropertyDatabase.process(System.in, properties, accessFlags);
        } else {
            for (String f : args) {
                FilterAndCombineBitfieldPropertyDatabase.process(new FileInputStream(f), properties, accessFlags);
            }
        }
        for (Map.Entry e : properties.entrySet()) {
            String key = (String)e.getKey();
            System.out.println(key + "," + accessFlags.get(key) + "|" + e.getValue());
        }
    }

    static Status getStatus(@DottedClassName String name) {
        if (name.startsWith("com.sun") || name.startsWith("com.oracle") || name.startsWith("sun") || name.startsWith("netscape")) {
            return Status.UNEXPOSED;
        }
        Status result = classStatus.get(name);
        if (result != null) {
            return result;
        }
        try {
            Class<?> c = Class.forName(name, false, ClassLoader.getSystemClassLoader());
            int accessFlags = c.getModifiers();
            result = (accessFlags & 5) != 0 ? Status.EXPOSED : Status.UNEXPOSED;
        }
        catch (Exception e) {
            result = Status.NOT_FOUND;
        }
        classStatus.put(name, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(@WillClose InputStream inSource, Map<String, Integer> properties, Map<String, Integer> accessFlags) throws UnsupportedEncodingException, IOException {
        BufferedReader in = new BufferedReader(Util.getReader(inSource));
        Pattern p = Pattern.compile("^(([^,]+),.+),([0-9]+)\\|([0-9]+)$");
        try {
            String s;
            while ((s = in.readLine()) != null) {
                Matcher m = p.matcher(s);
                if (!m.find()) continue;
                String key = m.group(1);
                String className = m.group(2);
                if (FilterAndCombineBitfieldPropertyDatabase.getStatus(className) == Status.UNEXPOSED) continue;
                int accFlags = Integer.parseInt(m.group(3));
                int bits = Integer.parseInt(m.group(4));
                if ((accFlags & 5) == 0) continue;
                accessFlags.put(key, accFlags);
                if (properties.containsKey(key)) {
                    properties.put(key, bits | properties.get(key));
                    continue;
                }
                properties.put(key, bits);
            }
        }
        finally {
            Util.closeSilently(in);
        }
    }

    static enum Status {
        NOT_FOUND,
        EXPOSED,
        UNEXPOSED;

    }
}

