/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class StartInConstructor
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;

    public StartInConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public boolean shouldVisit(JavaClass obj) {
        boolean isFinal = (obj.getAccessFlags() & 0x10) != 0 || (obj.getAccessFlags() & 1) == 0;
        return !isFinal;
    }

    @Override
    public void visit(Code obj) {
        if ("<init>".equals(this.getMethodName()) && (this.getMethod().isPublic() || this.getMethod().isProtected())) {
            super.visit(obj);
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 && "start".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand())) {
            try {
                if (Hierarchy.isSubtype(this.getDottedClassConstantOperand(), "java.lang.Thread")) {
                    int priority = 2;
                    if (this.getPC() + 4 >= this.getCode().getCode().length) {
                        priority = 3;
                    }
                    BugInstance bug = new BugInstance(this, "SC_START_IN_CTOR", priority).addClassAndMethod(this).addCalledMethod(this);
                    Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                    Set<ClassDescriptor> directSubtypes = subtypes2.getDirectSubtypes(this.getClassDescriptor());
                    if (!directSubtypes.isEmpty()) {
                        for (ClassDescriptor sub : directSubtypes) {
                            bug.addClass(sub).describe("CLASS_SUBCLASS");
                        }
                        bug.setPriority(1);
                    }
                    this.bugAccumulator.accumulateBug(bug, this);
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }
}

