/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MultithreadedInstanceAccess
extends OpcodeStackDetector {
    private static final String STRUTS_ACTION_NAME = "org.apache.struts.action.Action";
    private static final String SERVLET_NAME = "javax.servlet.Servlet";
    private final BugReporter bugReporter;
    private Set<JavaClass> mtClasses;
    private String mtClassName;
    private int monitorCount;
    private boolean writingField;
    private Set<String> alreadyReported;

    public MultithreadedInstanceAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private Set<JavaClass> getMtClasses() {
        if (this.mtClasses != null) {
            return this.mtClasses;
        }
        this.mtClasses = new HashSet<JavaClass>();
        try {
            this.mtClasses.add(Repository.lookupClass((String)STRUTS_ACTION_NAME));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            this.mtClasses.add(Repository.lookupClass((String)SERVLET_NAME));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.mtClasses;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            String superClsName = cls.getSuperclassName();
            if ("java.lang.Object".equals(superClsName)) {
                return;
            }
            if (STRUTS_ACTION_NAME.equals(superClsName)) {
                this.mtClassName = STRUTS_ACTION_NAME;
                super.visitClassContext(classContext);
            } else if (SERVLET_NAME.equals(superClsName)) {
                this.mtClassName = SERVLET_NAME;
                super.visitClassContext(classContext);
            } else {
                for (JavaClass mtClass : this.getMtClasses()) {
                    if (!(mtClass.isClass() ? cls.instanceOf(mtClass) : cls.implementationOf(mtClass))) continue;
                    this.mtClassName = mtClass.getClassName();
                    super.visitClassContext(classContext);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void visitMethod(Method obj) {
        this.monitorCount = 0;
        this.alreadyReported = new HashSet<String>();
        this.writingField = false;
    }

    @Override
    public boolean shouldVisitCode(Code code) {
        return !"<init>".equals(this.getMethodName()) && !"init".equals(this.getMethodName());
    }

    @Override
    public void sawField() {
        ConstantFieldref fieldRef;
        String className;
        if (this.monitorCount > 0 || !this.writingField) {
            return;
        }
        Constant c = this.getConstantRefOperand();
        if (c instanceof ConstantFieldref && (className = (fieldRef = (ConstantFieldref)c).getClass(this.getConstantPool()).replace('.', '/')).equals(this.getClassName())) {
            Field[] flds;
            ConstantPool cp = this.getConstantPool();
            int nameAndTypeIdx = fieldRef.getNameAndTypeIndex();
            ConstantNameAndType ntc = (ConstantNameAndType)cp.getConstant(nameAndTypeIdx);
            int nameIdx = ntc.getNameIndex();
            for (Field fld : flds = this.getClassContext().getJavaClass().getFields()) {
                if (fld.getNameIndex() != nameIdx) continue;
                if (fld.isStatic()) break;
                ConstantUtf8 nameCons = (ConstantUtf8)cp.getConstant(nameIdx);
                ConstantUtf8 typeCons = (ConstantUtf8)cp.getConstant(ntc.getSignatureIndex());
                if (this.alreadyReported.contains(nameCons.getBytes())) {
                    return;
                }
                this.alreadyReported.add(nameCons.getBytes());
                this.bugReporter.reportBug(new BugInstance(this, STRUTS_ACTION_NAME.equals(this.mtClassName) ? "MTIA_SUSPECT_STRUTS_INSTANCE_FIELD" : "MTIA_SUSPECT_SERVLET_INSTANCE_FIELD", 3).addField(new FieldAnnotation(this.getDottedClassName(), nameCons.getBytes(), typeCons.getBytes(), false)).addClass(this).addSourceLine(this));
                break;
            }
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 194) {
            ++this.monitorCount;
        } else if (seen == 195) {
            --this.monitorCount;
        }
        this.writingField = seen == 181 || seen == 207 || seen == 228;
    }
}

