/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;

public class FindRoughConstants
extends BytecodeScanningDetector {
    private static final BadConstant[] badConstants = new BadConstant[]{new BadConstant(Math.PI, 1.0, "Math.PI", 1), new BadConstant(Math.PI, 0.5, "Math.PI/2", 2), new BadConstant(Math.PI, 0.3333333333333333, "Math.PI/3", 3), new BadConstant(Math.PI, 0.25, "Math.PI/4", 3), new BadConstant(Math.PI, 2.0, "2*Math.PI", 2), new BadConstant(Math.E, 1.0, "Math.E", 3)};
    private final BugAccumulator bugAccumulator;
    private BugInstance lastBug;
    private int lastPriority;

    public FindRoughConstants(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (this.hasInterestingConstant(classContext.getJavaClass().getConstantPool())) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 18 || seen == 19 || seen == 20) {
            Constant c = this.getConstantRefOperand();
            if (c instanceof ConstantFloat) {
                this.checkConst(Float.valueOf(((ConstantFloat)c).getBytes()));
            } else if (c instanceof ConstantDouble) {
                this.checkConst(((ConstantDouble)c).getBytes());
            }
            return;
        }
        if (seen == 184 && this.lastBug != null && this.getNextOpcode() == 83 && this.getNameConstantOperand().equals("valueOf") && (this.getClassConstantOperand().equals("java/lang/Double") || this.getClassConstantOperand().equals("java/lang/Float"))) {
            this.lastBug = (BugInstance)this.lastBug.clone();
            this.lastBug.setPriority(this.lastPriority + 1);
            this.bugAccumulator.forgetLastBug();
            this.bugAccumulator.accumulateBug(this.lastBug, this);
        }
        this.lastBug = null;
    }

    private boolean hasInterestingConstant(ConstantPool cp) {
        for (Constant constant : cp.getConstantPool()) {
            float val;
            if (constant instanceof ConstantFloat && this.isInteresting(Float.valueOf(val = ((ConstantFloat)constant).getBytes()), val)) {
                return true;
            }
            if (!(constant instanceof ConstantDouble) || !this.isInteresting(val = ((ConstantDouble)constant).getBytes(), val)) continue;
            return true;
        }
        return false;
    }

    private boolean isInteresting(Number constValue, double candidate) {
        for (BadConstant badConstant : badConstants) {
            if (this.getPriority(badConstant, constValue, candidate) >= 5) continue;
            return true;
        }
        return false;
    }

    private int getPriority(BadConstant badConstant, Number constValue, double candidate) {
        if (badConstant.exact(constValue)) {
            return 5;
        }
        double diff = badConstant.diff(candidate);
        if (diff > 0.001) {
            return 5;
        }
        if (badConstant.equalPrefix(constValue)) {
            return diff > 1.0E-4 ? badConstant.basePriority + 1 : (diff < 1.0E-6 ? badConstant.basePriority - 1 : badConstant.basePriority);
        }
        if (diff > 1.0E-7) {
            return 5;
        }
        return badConstant.basePriority + 1;
    }

    private void checkConst(Number constValue) {
        double candidate = constValue.doubleValue();
        if (Double.isNaN(candidate) || Double.isInfinite(candidate)) {
            return;
        }
        for (BadConstant badConstant : badConstants) {
            int priority = this.getPriority(badConstant, constValue, candidate);
            if (this.getNextOpcode() == 81 || this.getNextOpcode() == 82) {
                ++priority;
            }
            if (priority >= 5) continue;
            this.lastPriority = priority;
            this.lastBug = new BugInstance(this, "CNT_ROUGH_CONSTANT_VALUE", priority).addClassAndMethod(this).addString(constValue.toString()).addString(badConstant.replacement);
            this.bugAccumulator.accumulateBug(this.lastBug, this);
            return;
        }
    }

    static class BadConstant {
        double base;
        double factor;
        String replacement;
        double value;
        int basePriority;
        Set<Number> approxSet = new HashSet<Number>();

        BadConstant(double base, double factor, String replacement, int basePriority) {
            this.base = base;
            this.factor = factor;
            this.value = this.base * this.factor;
            this.replacement = replacement;
            this.basePriority = basePriority;
            BigDecimal valueBig = BigDecimal.valueOf(this.value);
            BigDecimal baseBig = BigDecimal.valueOf(base);
            BigDecimal factorBig = BigDecimal.valueOf(factor);
            for (int prec = 0; prec < 14; ++prec) {
                this.addApprox(baseBig.round(new MathContext(prec, RoundingMode.FLOOR)).multiply(factorBig));
                this.addApprox(baseBig.round(new MathContext(prec, RoundingMode.CEILING)).multiply(factorBig));
                this.addApprox(valueBig.round(new MathContext(prec, RoundingMode.FLOOR)));
                this.addApprox(valueBig.round(new MathContext(prec, RoundingMode.CEILING)));
            }
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        public boolean exact(Number candidate) {
            if (candidate instanceof Double) {
                return candidate.doubleValue() == this.value;
            }
            return candidate.floatValue() == (float)this.value;
        }

        public double diff(double candidate) {
            return Math.abs(this.value - candidate) / this.value;
        }

        public boolean equalPrefix(Number candidate) {
            return this.approxSet.contains(candidate);
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        private void addApprox(BigDecimal roundFloor) {
            float approxFloat;
            double approxDouble = roundFloor.doubleValue();
            if (approxDouble != this.value && Math.abs(approxDouble - this.value) / this.value < 0.001) {
                this.approxSet.add(approxDouble);
            }
            if (Math.abs((double)(approxFloat = roundFloor.floatValue()) - this.value) / this.value < 0.001) {
                this.approxSet.add(Float.valueOf(approxFloat));
                this.approxSet.add(approxFloat);
            }
        }
    }
}

