/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;

public class DebugRepositoryLookupFailureCallback
implements RepositoryLookupFailureCallback {
    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (missing == null || missing.charAt(0) == '[') {
            return;
        }
        System.out.println("Missing class");
        ex.printStackTrace();
        System.exit(1);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void reportMissingClass(ClassDescriptor classDescriptor) {
        System.out.println("Missing class: " + classDescriptor);
        System.exit(1);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void logError(String message) {
        System.err.println("Error: " + message);
        System.exit(1);
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void logError(String message, Throwable e) {
        if (e instanceof MissingClassException) {
            MissingClassException missingClassEx = (MissingClassException)e;
            ClassNotFoundException cnfe = missingClassEx.getClassNotFoundException();
            this.reportMissingClass(cnfe);
            return;
        }
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        System.err.println("Error: " + message);
        e.printStackTrace();
        System.exit(1);
    }

    @Override
    public void reportSkippedAnalysis(MethodDescriptor method) {
        System.err.println("Skipping " + method);
    }
}

